﻿using FAQ.Models;
using FAQ.Repository.Contracts;
using Microsoft.AspNetCore.Mvc;

namespace FAQ.Controllers
{
    public class FAQController : Controller
    {
        private IQuestionRepository QuestionRepository;

        /// <summary>
        /// Initialise une nouvelle instance du contrôleur avec le dépôt spécifié.
        /// </summary>
        /// <param name="versionRepository">Le dépôt des versions.</param>
        public FAQController(IQuestionRepository QuestionRepository)
        {
            this.QuestionRepository = QuestionRepository;
        }

        /// <summary>
        /// Affiche la page d'index.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        public IActionResult Index()
        {
            var model = new FAQIndexViewModel();

            model.Questions = QuestionRepository.FindAll();

            return View(model);
        }

        /// <summary>
        /// Affiche la page d'ajout de question.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        public IActionResult Add()
        {

            return View(new FAQEditViewModel());
        }

        /// <summary>
        /// Affiche la page qui permet d'ajouter des questions/réponses.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        [HttpPost]
        public IActionResult Add(FAQEditViewModel model)
        {
            if (this.ModelState.IsValid)
            {
                string categorie = model.Categorie;
                int id = QuestionRepository.Last().IdQuestion + 1;
                string Reponse = model.Question;
                string Question = model.Question;
                string DateCreation = DateTime.Now.ToString();

                this.QuestionRepository.Add(new Entities.Question(id, Question, Reponse, DateCreation, null, categorie));
                return RedirectToAction(nameof(Index));
            }
            else
            {
                this.ModelState.AddModelError("", "Zut c'est vide");
                return View(model);
            }
        }

        /// <summary>
        /// Supprime des questions.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        [HttpPost]
        public IActionResult RemoveQuestion(int id)
        {
            this.QuestionRepository.RemoveQuestion(id);
            return RedirectToAction(nameof(Index));
        }

        /// <summary>
        /// Affiche la page de la question et ses caractéristiques.
        /// </summary>
        /// <returns>Vue de la pagfe de la question. </returns>
        public IActionResult Question(int id)
        {
            var model = new FAQQuestionViewModel();
            var question = QuestionRepository.FindAll().First(q => q.IdQuestion == id);
            model.Titre = question.Titre;
            model.Reponse = question.Reponse;
            model.DateCreation = question.Date_Creation;
            model.DateModification = question.Date_Modif;


            return View(model);
        }

        /// <summary>
        /// Affiche la page de modification.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        public IActionResult Modification(string titre)
        {
            var model = new FAQModificationViewModel();
            var question = QuestionRepository.FindAll().First(q => q.Titre == titre);
            model.Reponse = question.Reponse;
            model.Titre = titre;
            return View(model);
        }

        /// <summary>
        ///Modifie une question.
        /// </summary>
        /// <returns>Page d'accueil</returns>
        [HttpPost]
        public IActionResult Modification(FAQModificationViewModel model)
        {

            string Titre = model.Titre;
            var question = QuestionRepository.FindAll().First(q => q.Titre == Titre);

            question.Reponse = model.NouvelleReponse;

            if (model.Titre != null)
            {
                question.Titre = model.NouveauTitre;
            }
            question.Date_Modif = DateTime.Now.ToString();

            return RedirectToAction(nameof(Index));
        }
        /// <summary>
        /// Affiche la page de la catégorie et ses questions
        /// </summary>
        /// <returns>Page d'accueil</returns>
        public IActionResult Categorie(string categorie)
        {
            var model = new FAQCategorieViewModel();
            var questions = this.QuestionRepository.FindAll().Where(q => q.Categorie == categorie).ToList();
            model.Questions = questions;
            return View(model);
        }
    }
}
